<?php
/**
* @package icarus
* @subpackage form-markup-generator
*/

/**
* @uses _text_area.php
* @uses _text_area_field.php
* @uses _label.php
*
* @package icarus
* @subpackage form-markup-generator
*/
class Text_area_markup_generator extends Field_markup_generator{
	protected $_type = 'text_area';	
	protected $_inline = false;
	protected $validation_method = 'string';
	protected $_security_validation_method = 'isValidString';
	protected $_security_sanitization_method = 'sanitizeString';
	
	protected $_property_validation_rules = array('type' => 'boolean');	  
	
	function attributes(){
		$default_attributes = array('name' => $this->name_for_markup(), 'value' => $this->raw_value);		
		
		return merge_attributes($default_attributes, parent::attributes());
	}
	
	function classes($suffix = '-field'){
		$classes = parent::classes($suffix);
		if(!$this->inline)
			$classes[] = 'not-inline';
		return $classes;
	}
	
}